#include "General.h"
#include "LeaveDeathsExploitFix.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

LeaveDeathsExploitFix::LeaveDeathsExploitFix()
{
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

LeaveDeathsExploitFix::~LeaveDeathsExploitFix()
{
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

void LeaveDeathsExploitFix::OnPlayerLeave(int PlayerID)
{
	GameObject *obj = Get_GameObj(PlayerID);

	if ( Commands->Get_Health(obj) == 0.0f ) 
	{ 
		Find_Player(PlayerID)->Set_Deaths(Find_Player(PlayerID)->Get_Deaths()+1); 
	}
}

LeaveDeathsExploitFix leaveDeathsExploitFix;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &leaveDeathsExploitFix;
}
